import glob
import os
import librosa
from librosa import display
import numpy as np
import matplotlib
#matplotlib.use("Agg")

import matplotlib.pyplot as plt
#import tensorflow as tf
from matplotlib.pyplot import specgram
#%matplotlib inline

def load_sound_files(file_paths):
    raw_sounds = []
    for fp in file_paths:
        X,sr = librosa.load(fp)
        raw_sounds.append(X)
    return raw_sounds

def plot_waves(sound_names,raw_sounds):
    i = 1
    fig = plt.subplot(111)
    for n,f in zip(sound_names,raw_sounds):
        plt.subplot(1,1,i)
        display.waveplot(np.array(f),sr=8000)
        #plt.title(n.title())
        i += 1
    plt.suptitle("Figure 1: Waveplot",x=0.5, y=0.915,fontsize=14)
    plt.show()
    
def plot_specgram(sound_names,raw_sounds):
    i = 1
    fig = plt.subplot(111)
    for n,f in zip(sound_names,raw_sounds):
        plt.subplot(1,1,i)
        specgram(np.array(f), NFFT=300, noverlap=80, Fs=8000)
        #plt.title(n.title())
        i += 1
    plt.suptitle("Figure 2: Spectrogram",x=0.5, y=0.915,fontsize=14)
    print ("All is Well") 
    plt.show()

def plot_log_power_specgram(sound_names,raw_sounds):
    i = 1
    fig = plt.subplot(111)
    for n,f in zip(sound_names,raw_sounds):
        plt.subplot(1,1,i)
        D = librosa.logamplitude(np.abs(librosa.stft(f))**2, ref_power=np.max)
        librosa.display.specshow(D,x_axis='time' ,y_axis='log')
        #plt.title(n.title())
        i += 1
    plt.suptitle("Figure 3: Log power spectrogram",x=0.5, y=0.915,fontsize=14)
    plt.show()

sound_file_paths = ["/home/pghosh/aravind/Completed/OpenDay17/Mix1/bassoon_syn.wav"] 
#,"24074-1-0-3.wav","15564-2-0-1.wav","31323-3-0-1.wav",
#] 
#"46669-4-0-35.wav","89948-5-0-0.wav","40722-8-0-4.wav",
#"103074-7-3-2.wav","106905-8-0-0.wav","108041-9-0-4.wav"]

sound_names = ["air conditioner"]

#,"car horn","children playing",
#"dog bark","drilling","engine idling", "gun shot",
#"jackhammer","siren","street music"]

raw_sounds = load_sound_files(sound_file_paths)
plt.figure(1)
print "Loaded the file.."
plot_waves(sound_names,raw_sounds)
plot_specgram(sound_names,raw_sounds)
#plot_log_power_specgram(sound_names,raw_sounds)
